/*

BSD License

Copyright (c) 2002, Brent Simmons
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

*	Redistributions of source code must retain the above copyright notice,
	this list of conditions and the following disclaimer.
*	Redistributions in binary form must reproduce the above copyright notice,
	this list of conditions and the following disclaimer in the documentation
	and/or other materials provided with the distribution.
*	Neither the name of ranchero.com or Brent Simmons nor the names of its
	contributors may be used to endorse or promote products derived
	from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


*/

/*
	PreferenceController.m
	Huevos

	Created by Brent Simmons on Wed Apr 03 2002.
	Copyright (c) 2002 Brent Simmons. All rights reserved.
*/


#import "PreferenceController.h"
#import "SearchEngines.h"
#import "Huevos.h"
#import "HotKeyPrefs.h"


@implementation PreferenceController


- (id) init {
	
	self = [super initWithWindowNibName: @"Preferences"];
	
	return (self);
	} /*init*/
	
	
- (void) windowDidLoad {
		
	[self initHotKeyPopup];
	
	[self updateHotKeyPopups];
	} /*windowDidLoad*/
	
	
/*HotKey prefs*/

- (void) updateHotKeyPopups {
	
	[hotKeyModifierPopup selectItemAtIndex: [HotKeyPrefs hotKeyModifier]];
	
	[hotKeyPopup selectItemAtIndex: [HotKeyPrefs hotKey]];
	} /*updateHotKeyPopups*/


- (void) initHotKeyPopup {
	
	NSArray *hotKeyTitles = [NSArray arrayWithObjects: @"Esc", @"F1",
		@"F2", @"F3", @"F4", @"F5", @"F6",
		@"F7", @"F8", @"F9", @"F10", @"F11", @"F12", nil];
		
	[hotKeyPopup removeAllItems]; /*clear it*/
	
	[hotKeyPopup addItemsWithTitles: hotKeyTitles];	
	} /*initHotKeyPopup*/


/*Edit search engine sheet*/

- (void) updateSearchEngineSheetControls: (NSString *) name url: (NSString *) url
	key: (NSString *) key {
	
	if (name == nil)
		name = @"";
	
	if (url == nil)
		url = @"";
	
	if (key == nil)
		key = @"";
	
	key = [key uppercaseString]; /*Display as uppercase, even though internally lowercase is used.*/
	
	[nameField setStringValue: name];
	
	[urlField setStringValue: url];
	
	[keyField setStringValue: key];
	} /*updateSearchEngineSheetControls*/
	
	
- (void) updateSearchEngineSheetControls: (NSString *) searchEngineName {
	
	NSString *url = [SearchEngines urlFromName: searchEngineName];
	NSString *key = [SearchEngines commandKeyForSearchEngine: searchEngineName];
	
	[self updateSearchEngineSheetControls: searchEngineName url: url key: key];
	} /*updateSearchEngineSheetControls*/
	

- (void) runSheet: (NSWindow *) sheet {
			
	[NSApp beginSheet: sheet modalForWindow: mainWindow 
		modalDelegate: nil didEndSelector: nil contextInfo: nil];
	
	[NSApp runModalForWindow: sheet];

	[NSApp endSheet: sheet];

	[sheet orderOut: self];
	
	[mainWindow makeKeyAndOrderFront: self];
	} /*runSheet*/
	

static NSString *currentSearchEngine = nil;

- (IBAction) okSearchEngineSheet: (id) sender {
	
	NSString *newName, *newURL, *newKey;

	newName = [nameField stringValue];
		
	newURL = [urlField stringValue];
	
	newKey = [keyField stringValue];
 
	if (![newName isEqualToString: @""]) {
	
		if (currentSearchEngine == nil) { /*new search engine?*/
		
			[SearchEngines new: newName url: newURL];
			
			if (![newKey isEqualToString: @""])
				if (![newKey isEqualToString: @" "])
					[SearchEngines setCommandKeyForSearchEngine: newKey name: newName];			
			} /*if*/
		
		else { /*update existing search engine*/
			
			int n = [SearchEngines indexOfSearchEngine: currentSearchEngine];
						
			[SearchEngines setNthCommandKey: newKey n: n];
			
			[SearchEngines setNthUrl: newURL n: n];
			
			if (![currentSearchEngine isEqualToString: newName])
				[SearchEngines renameNthSearchEngine: newName n: n];
			} /*else*/
		} /*if*/
		
	[NSApp stopModal];
	} /*okSearchEngineSheet*/


- (IBAction) cancelSearchEngineSheet: (id) sender {
	
	[NSApp stopModal];
	} /*cancelSearchEngineSheet*/
	
	
- (void) setCurrentSearchEngine: (NSString *) name {
	
	if (currentSearchEngine != nil)
		[currentSearchEngine autorelease];
	
	if (name == nil)
		currentSearchEngine = nil;
	else
		currentSearchEngine = [name retain];
	} /*setCurrentSearchEngine*/
	
	
- (void) runSearchEngineSheet: (NSString *) searchEngineName {
	
	[self updateSearchEngineSheetControls: searchEngineName];
	
	[self setCurrentSearchEngine: searchEngineName];
	
	[self runSheet: editSearchEngineSheet];
	} /*runSearchEngineSheet*/


- (void) runNewSearchEngineSheet {
	
	[self updateSearchEngineSheetControls: @"" url: @"" key: @""];

	[self setCurrentSearchEngine: nil];
	
	[self runSheet: editSearchEngineSheet];
	} /*runNewSearchEngineSheet*/
	

/*Actions*/


- (IBAction) newButton: (id) sender {
	
	[self runNewSearchEngineSheet];	
	} /*newButton*/
	

- (IBAction) editButton: (id) sender {
	
	int ix = [tableView selectedRow];
	NSString *name = [SearchEngines nthSearchEngineName: ix]; 
	
	[self runSearchEngineSheet: name];
	} /*editButton*/


- (IBAction) deleteButton: (id) sender {
	
	int row = [tableView selectedRow];
	
	if (row != -1) { /*Run a sheet confirming the delete.*/
		
		/*End editing.*/
		
		[tableView abortEditing];
		
		/*Run the alert sheet.*/
	
		NSBeginAlertSheet (@"Delete", @"Delete", @"Dont Delete", nil,
			[self window], self, @selector (sheetDidEnd: returnCode: contextInfo:),
			nil, nil,
			[NSString stringWithFormat:
			@"Are you sure you want to delete %@? This operation cannot be undone.",
			[SearchEngines nthSearchEngineName: row]]);
		} /*if*/		
	} /*deleteButton*/


- (void) sheetDidEnd: (NSWindow *) sheet returnCode: (int) returnCode
	contextInfo: (void *) contextInfo {
	
	int row = [tableView selectedRow];
	
	if ((row != -1) && (returnCode == NSAlertDefaultReturn)) {
		
		[SearchEngines deleteNthSearchEngine: row]; /*Delete that row*/
		
		[tableView reloadData]; /*Reload data in table view.*/
		} /*if*/
	} /*sheetDidEnd*/


- (IBAction) updateHotKeyModifier: (id) sender {
	
	[HotKeyPrefs setHotKeyModifier: [sender indexOfSelectedItem]];
	} /*updateHotKeyModifier*/
	

- (IBAction) updateHotKey: (id) sender {
	
	[HotKeyPrefs setHotKey: [sender indexOfSelectedItem]];	
	} /*updateHotKey*/


/*Table view data source and delegate methods.*/

- (int) numberOfRowsInTableView: (NSTableView *) aTableView {
	
	return [SearchEngines count];
	} /*numberOfRowsInTableView*/


- (id) tableView: (NSTableView *) aTableView
	objectValueForTableColumn: (NSTableColumn *) tableColumn
	row: (int) row {
	
	return [SearchEngines nthSearchEngineName: row];
	} /*tableView: objectValueForTableColumn*/


- (BOOL) tableView: (NSTableView *) tableView
	shouldEditTableColumn: (NSTableColumn *) column
	row: (int) row {
	
	NSString *name = [SearchEngines nthSearchEngineName: row]; 
	
	[self runSearchEngineSheet: name];

	return (NO);
	} /*tableView: shouldEditTableColmn*/
	

@end
